# スピードアップグレード
実行速度が2倍になりました。問題は、ドローンが草の成長よりも速く収穫するようになり、全く収穫できなくなってしまうことです。これに対処するために、[if](docs/scripting/if.md)分岐と[can_harvest](functions/can_harvest)関数がアンロックされました。

## 収穫する前にチェックする
今までは `True` と `False` しか条件として使えませんでしたが、これでは `if` 文であまり役に立ちません。

新しい関数 `can_harvest()` は、より良い条件を提供します。`can_harvest()` は、ドローンの下の植物が収穫できる場合は `True` を、そうでない場合は `False` を返します。

`if can_harvest():
	#何かをする`

この関数をこのように条件として使える理由は、ブール値を返すからです。

戻り値というのは、関数が実行された後、関数を呼び出した部分が、その関数から返された値に置き換わる、ということです。

上記のコードが実行されると、次のようになります：
	- if文が実行されます
	- `can_harvest()` が呼び出されます
	- `can_harvest()` がその処理を行います
	- `can_harvest()` が `True` または `False` を返します
	- 文は `if True:` または `if False:` になります
	- 収穫できる場合のみ、コードブロックが実行されます

これで `if` を使って、ドローンが早すぎる収穫をするのを防ぐことができます。